	.INCLUDE	"global.inc"
	.IMPORT	RAYCAST
	.IMPORT	RENDERSTATUS, RENDERPAGE
	.EXPORT	RENDER
	
	.CODE
	
;**************************************
;*
;* RENDER VIEW GIVEN LOCATION AND ANGLE.
;* CALL RAYCASTER FOR EACH VERTICAL SEGMENT.
;*
;**************************************

RENDER:	LDA	PLAYERA
	SEC
	SBC	#19
	CLC
	ADC	VIEWCOLLEFT
	STA	RAYA
	LDA	VIEWCOLLEFT
	STA	VIEWCOL
RENDERLOOP:	JSR	RAYCAST
	LDA	HITDIST+1
	LSR
	STA	WALLSCALE+1
	LDA	HITDIST
	ROR
	STA	WALLSCALE
	LSR	WALLSCALE+1
	ROR	WALLSCALE
	LSR	WALLSCALE+1
	ROR	WALLSCALE
	LDA	HITOBJ
	AND	#$F0
	BEQ	VERTHIT
	LSR		;GET HITOBJ INDEX
	LSR
	LSR
	LSR
	CLC
	ADC	TEXBASE+1
	STA	TEXPTR+1
	LDA	HITX	;HORIZ HIT, USE HITX
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	TEXBASE
	STA	TEXPTR
	LDA	#$00
	ADC	TEXPTR+1
	STA	TEXPTR+1
	JMP	DRAWWALLS
VERTHIT:	LDA	HITOBJ	;RECOVER HITOBJ INDEX
	CLC
	ADC	TEXBASE+1
	STA	TEXPTR+1
	LDA	HITY	;VERT HIT, USE HITY
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	TEXBASE
	STA	TEXPTR
	LDA	#$00
	ADC	TEXPTR+1
	STA	TEXPTR+1
DRAWWALLS:	LDA	RENDERPAGE
	BEQ	DRAWPG1
	LDA	RENDERSTATUS
	BNE	DRAWPG2S
	JMP	WALL2UPR
DRAWPG2S:	JMP	WALL2UPRS
DRAWPG1:	LDA	RENDERSTATUS
	BNE	WALL1UPRS
	JMP	WALL1UPR
;
; DRAW UPPER HALF OF WALL W/ STATUS - PAGE 1
;
WALL1UPRS:	LDX	VIEWCOL
	LDA	#WALLUPRORGFRAC
	STA	WALLINDX
	LDY	#WALLUPRORGINT
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS1
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$4A8,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS2
WALL1UPRS1:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$4A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS2
	LDA	CLRCEIL
	JMP	CEIL1FILLS2
WALL1UPRS2:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS3
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$428,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS3
WALL1UPRS3:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$428,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS4
	LDA	CLRCEIL
	JMP	CEIL1FILLS3
WALL1UPRS4:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS5
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$780,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS4
WALL1UPRS5:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$780,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS6
	LDA	CLRCEIL
	JMP	CEIL1FILLS4
WALL1UPRS6:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS7
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$700,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS5
WALL1UPRS7:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$700,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS8
	LDA	CLRCEIL
	JMP	CEIL1FILLS5
WALL1UPRS8:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS9
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$680,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS6
WALL1UPRS9:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$680,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS10
	LDA	CLRCEIL
	JMP	CEIL1FILLS6
WALL1UPRS10:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS11
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$600,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS7
WALL1UPRS11:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$600,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS12
	LDA	CLRCEIL
	JMP	CEIL1FILLS7
WALL1UPRS12:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS13
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$580,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS8
WALL1UPRS13:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$580,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS14
	LDA	CLRCEIL
	JMP	CEIL1FILLS8
WALL1UPRS14:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS15
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$500,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS9
WALL1UPRS15:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$500,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS16
	LDA	CLRCEIL
	JMP	CEIL1FILLS9
WALL1UPRS16:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS17
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$480,X
	LDA	CLRCEIL
	JMP	CEIL1FILLS10
WALL1UPRS17:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$480,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS18
	LDA	CLRCEIL
	JMP	CEIL1FILLS10
WALL1UPRS18:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPRS19
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$400,X
	JMP	WALL1LWRS
WALL1UPRS19:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$400,X
	JMP	WALL1LWRS
;
; DRAW CEILING W/ STATUS
;
CEIL1FILLS1:	STA	$4A8,X
CEIL1FILLS2:	STA	$428,X
CEIL1FILLS3:	STA	$780,X
CEIL1FILLS4:	STA	$700,X
CEIL1FILLS5:	STA	$680,X
CEIL1FILLS6:	STA	$600,X
CEIL1FILLS7:	STA	$580,X
CEIL1FILLS8:	STA	$500,X
CEIL1FILLS9:	STA	$480,X
CEIL1FILLS10:	STA	$400,X
;
; DRAW LOWER HALF OF WALL W/ STATUS
;
WALL1LWRS:	LDA	#WALLLWRORGFRAC
	STA	WALLINDX
	LDY	#WALLLWRORGINT
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	CLC
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS1
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$528,X
	LDA	CLRFLR
	JMP	FLR1FILLS2
WALL1LWRS1:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$528,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS2
	LDA	CLRFLR
	JMP	FLR1FILLS2
WALL1LWRS2:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS3
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$5A8,X
	LDA	CLRFLR
	JMP	FLR1FILLS3
WALL1LWRS3:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$5A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS4
	LDA	CLRFLR
	JMP	FLR1FILLS3
WALL1LWRS4:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS5
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$628,X
	LDA	CLRFLR
	JMP	FLR1FILLS4
WALL1LWRS5:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$628,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS6
	LDA	CLRFLR
	JMP	FLR1FILLS4
WALL1LWRS6:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS7
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$6A8,X
	LDA	CLRFLR
	JMP	FLR1FILLS5
WALL1LWRS7:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$6A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS8
	LDA	CLRFLR
	JMP	FLR1FILLS5
WALL1LWRS8:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS9
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$728,X
	LDA	CLRFLR
	JMP	FLR1FILLS6
WALL1LWRS9:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$728,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS10
	LDA	CLRFLR
	JMP	FLR1FILLS6
WALL1LWRS10:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS11
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$7A8,X
	LDA	CLRFLR
	JMP	FLR1FILLS7
WALL1LWRS11:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$7A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS12
	LDA	CLRFLR
	JMP	FLR1FILLS7
WALL1LWRS12:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS13
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$450,X
	LDA	CLRFLR
	JMP	FLR1FILLS8
WALL1LWRS13:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$450,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS14
	LDA	CLRFLR
	JMP	FLR1FILLS8
WALL1LWRS14:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS15
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$4D0,X
	LDA	CLRFLR
	JMP	FLR1FILLS9
WALL1LWRS15:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$4D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS16
	LDA	CLRFLR
	JMP	FLR1FILLS9
WALL1LWRS16:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS17
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$550,X
	LDA	CLRFLR
	JMP	FLR1FILLS10
WALL1LWRS17:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$550,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS18
	LDA	CLRFLR
	JMP	FLR1FILLS10
WALL1LWRS18:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWRS19
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$5D0,X
	LDA	HITCNT
	BNE	WALL1SPRTS1
	JMP	DRAWNEXT
WALL1SPRTS1:	JMP	SPRT1UPRS1
WALL1LWRS19:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$5D0,X
	LDA	HITCNT
	BNE	WALL1SPRTS2
	JMP	DRAWNEXT
WALL1SPRTS2:	JMP	SPRT1UPRS1
;
; DRAW FLOOR W/ STATUS
;
FLR1FILLS1:	STA	$528,X
FLR1FILLS2:	STA	$5A8,X
FLR1FILLS3:	STA	$628,X
FLR1FILLS4:	STA	$6A8,X
FLR1FILLS5:	STA	$728,X
FLR1FILLS6:	STA	$7A8,X
FLR1FILLS7:	STA	$450,X
FLR1FILLS8:	STA	$4D0,X
FLR1FILLS9:	STA	$550,X
FLR1FILLS10:	STA	$5D0,X
	LDA	HITCNT
	BNE	WALL1SPRTS3
	JMP	DRAWNEXT
WALL1SPRTS3:	JMP	SPRT1UPRS1
;
; DRAW UPPER HALF OF WALL - PAGE 1
;
WALL1UPR:	LDX	VIEWCOL
	LDA	#WALLUPRORGFRAC
	STA	WALLINDX
	LDY	#WALLUPRORGINT
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR1
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$5A8,X
	LDA	CLRCEIL
	JMP	CEIL1FILL2
WALL1UPR1:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$5A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR2
	LDA	CLRCEIL
	JMP	CEIL1FILL2
WALL1UPR2:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR3
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$528,X
	LDA	CLRCEIL
	JMP	CEIL1FILL3
WALL1UPR3:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$528,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR4
	LDA	CLRCEIL
	JMP	CEIL1FILL3
WALL1UPR4:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR5
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$4A8,X
	LDA	CLRCEIL
	JMP	CEIL1FILL4
WALL1UPR5:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$4A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR6
	LDA	CLRCEIL
	JMP	CEIL1FILL4
WALL1UPR6:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR7
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$428,X
	LDA	CLRCEIL
	JMP	CEIL1FILL5
WALL1UPR7:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$428,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR8
	LDA	CLRCEIL
	JMP	CEIL1FILL5
WALL1UPR8:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR9
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$780,X
	LDA	CLRCEIL
	JMP	CEIL1FILL6
WALL1UPR9:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$780,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR10
	LDA	CLRCEIL
	JMP	CEIL1FILL6
WALL1UPR10:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR11
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$700,X
	LDA	CLRCEIL
	JMP	CEIL1FILL7
WALL1UPR11:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$700,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR12
	LDA	CLRCEIL
	JMP	CEIL1FILL7
WALL1UPR12:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR13
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$680,X
	LDA	CLRCEIL
	JMP	CEIL1FILL8
WALL1UPR13:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$680,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR14
	LDA	CLRCEIL
	JMP	CEIL1FILL8
WALL1UPR14:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR15
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$600,X
	LDA	CLRCEIL
	JMP	CEIL1FILL9
WALL1UPR15:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$600,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR16
	LDA	CLRCEIL
	JMP	CEIL1FILL9
WALL1UPR16:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR17
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$580,X
	LDA	CLRCEIL
	JMP	CEIL1FILL10
WALL1UPR17:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$580,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR18
	LDA	CLRCEIL
	JMP	CEIL1FILL10
WALL1UPR18:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR19
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$500,X
	LDA	CLRCEIL
	JMP	CEIL1FILL11
WALL1UPR19:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$500,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR20
	LDA	CLRCEIL
	JMP	CEIL1FILL11
WALL1UPR20:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR21
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$480,X
	LDA	CLRCEIL
	JMP	CEIL1FILL12
WALL1UPR21:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$480,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR22
	LDA	CLRCEIL
	JMP	CEIL1FILL12
WALL1UPR22:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL1UPR23
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$400,X
	JMP	WALL1LWR
WALL1UPR23:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$400,X	
	JMP	WALL1LWR
;
; DRAW CEILING 
;
CEIL1FILL1:	STA	$5A8,X
CEIL1FILL2:	STA	$528,X
CEIL1FILL3:	STA	$4A8,X
CEIL1FILL4:	STA	$428,X
CEIL1FILL5:	STA	$780,X
CEIL1FILL6:	STA	$700,X
CEIL1FILL7:	STA	$680,X
CEIL1FILL8:	STA	$600,X
CEIL1FILL9:	STA	$580,X
CEIL1FILL10:	STA	$500,X
CEIL1FILL11:	STA	$480,X
CEIL1FILL12:	STA	$400,X
;
; DRAW LOWER HALF OF WALL
;
WALL1LWR:	LDA	#WALLLWRORGFRAC
	STA	WALLINDX
	LDY	#WALLLWRORGINT
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	CLC
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR1
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$628,X
	LDA	CLRFLR
	JMP	FLR1FILL2
WALL1LWR1:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$628,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR2
	LDA	CLRFLR
	JMP	FLR1FILL2
WALL1LWR2:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR3
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$6A8,X
	LDA	CLRFLR
	JMP	FLR1FILL3
WALL1LWR3:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$6A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR4
	LDA	CLRFLR
	JMP	FLR1FILL3
WALL1LWR4:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR5
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$728,X
	LDA	CLRFLR
	JMP	FLR1FILL4
WALL1LWR5:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$728,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR6
	LDA	CLRFLR
	JMP	FLR1FILL4
WALL1LWR6:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR7
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$7A8,X
	LDA	CLRFLR
	JMP	FLR1FILL5
WALL1LWR7:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$7A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR8
	LDA	CLRFLR
	JMP	FLR1FILL5
WALL1LWR8:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR9
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$450,X
	LDA	CLRFLR
	JMP	FLR1FILL6
WALL1LWR9:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$450,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR10
	LDA	CLRFLR
	JMP	FLR1FILL6
WALL1LWR10:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR11
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$4D0,X
	LDA	CLRFLR
	JMP	FLR1FILL7
WALL1LWR11:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$4D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR12
	LDA	CLRFLR
	JMP	FLR1FILL7
WALL1LWR12:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR13
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$550,X
	LDA	CLRFLR
	JMP	FLR1FILL8
WALL1LWR13:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$550,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR14
	LDA	CLRFLR
	JMP	FLR1FILL8
WALL1LWR14:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR15
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$5D0,X
	LDA	CLRFLR
	JMP	FLR1FILL9
WALL1LWR15:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$5D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR16
	LDA	CLRFLR
	JMP	FLR1FILL9
WALL1LWR16:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR17
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$650,X
	LDA	CLRFLR
	JMP	FLR1FILL10
WALL1LWR17:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$650,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR18
	LDA	CLRFLR
	JMP	FLR1FILL10
WALL1LWR18:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR19
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$6D0,X
	LDA	CLRFLR
	JMP	FLR1FILL11
WALL1LWR19:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$6D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR20
	LDA	CLRFLR
	JMP	FLR1FILL11
WALL1LWR20:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR21
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$750,X
	LDA	CLRFLR
	JMP	FLR1FILL12
WALL1LWR21:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$750,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR22
	LDA	CLRFLR
	JMP	FLR1FILL12
WALL1LWR22:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL1LWR23
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$7D0,X
	LDA	HITCNT
	BNE	WALL1SPRT1
	JMP	DRAWNEXT
WALL1SPRT1:	JMP	SPRT1UPR1
WALL1LWR23:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$7D0,X
	LDA	HITCNT
	BNE	WALL1SPRT2
	JMP	DRAWNEXT
WALL1SPRT2:	JMP	SPRT1UPR1
;
; DRAW FLOOR
;
FLR1FILL1:	STA	$628,X
FLR1FILL2:	STA	$6A8,X
FLR1FILL3:	STA	$728,X
FLR1FILL4:	STA	$7A8,X
FLR1FILL5:	STA	$450,X
FLR1FILL6:	STA	$4D0,X
FLR1FILL7:	STA	$550,X
FLR1FILL8:	STA	$5D0,X
FLR1FILL9:	STA	$650,X
FLR1FILL10:	STA	$6D0,X
FLR1FILL11:	STA	$750,X
FLR1FILL12:	STA	$7D0,X
	LDA	HITCNT
	BNE	WALL1SPRT3
	JMP	DRAWNEXT
WALL1SPRT3:	JMP	SPRT1UPR1
;
; DRAW UPPER HALF OF WALL W/ STATUS - PAGE 2
;
WALL2UPRS:	LDX	VIEWCOL
	LDA	#WALLUPRORGFRAC
	STA	WALLINDX
	LDY	#WALLUPRORGINT
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS1
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$8A8,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS2
WALL2UPRS1:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$8A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS2
	LDA	CLRCEIL
	JMP	CEIL2FILLS2
WALL2UPRS2:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS3
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$828,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS3
WALL2UPRS3:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$828,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS4
	LDA	CLRCEIL
	JMP	CEIL2FILLS3
WALL2UPRS4:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS5
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$B80,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS4
WALL2UPRS5:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$B80,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS6
	LDA	CLRCEIL
	JMP	CEIL2FILLS4
WALL2UPRS6:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS7
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$B00,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS5
WALL2UPRS7:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$B00,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS8
	LDA	CLRCEIL
	JMP	CEIL2FILLS5
WALL2UPRS8:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS9
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$A80,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS6
WALL2UPRS9:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$A80,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS10
	LDA	CLRCEIL
	JMP	CEIL2FILLS6
WALL2UPRS10:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS11
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$A00,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS7
WALL2UPRS11:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$A00,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS12
	LDA	CLRCEIL
	JMP	CEIL2FILLS7
WALL2UPRS12:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS13
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$980,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS8
WALL2UPRS13:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$980,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS14
	LDA	CLRCEIL
	JMP	CEIL2FILLS8
WALL2UPRS14:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS15
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$900,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS9
WALL2UPRS15:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$900,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS16
	LDA	CLRCEIL
	JMP	CEIL2FILLS9
WALL2UPRS16:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS17
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$880,X
	LDA	CLRCEIL
	JMP	CEIL2FILLS10
WALL2UPRS17:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$880,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS18
	LDA	CLRCEIL
	JMP	CEIL2FILLS10
WALL2UPRS18:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPRS19
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$800,X
	JMP	WALL2LWRS
WALL2UPRS19:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$800,X
	JMP	WALL2LWRS
;
; DRAW CEILING W/ STATUS
;
CEIL2FILLS1:	STA	$8A8,X
CEIL2FILLS2:	STA	$828,X
CEIL2FILLS3:	STA	$B80,X
CEIL2FILLS4:	STA	$B00,X
CEIL2FILLS5:	STA	$A80,X
CEIL2FILLS6:	STA	$A00,X
CEIL2FILLS7:	STA	$980,X
CEIL2FILLS8:	STA	$900,X
CEIL2FILLS9:	STA	$880,X
CEIL2FILLS10:	STA	$800,X
;
; DRAW LOWER HALF OF WALL W/ STATUS
;
WALL2LWRS:	LDA	#WALLLWRORGFRAC
	STA	WALLINDX
	LDY	#WALLLWRORGINT
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	CLC
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS1
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$928,X
	LDA	CLRFLR
	JMP	FLR2FILLS2
WALL2LWRS1:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$928,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS2
	LDA	CLRFLR
	JMP	FLR2FILLS2
WALL2LWRS2:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS3
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$9A8,X
	LDA	CLRFLR
	JMP	FLR2FILLS3
WALL2LWRS3:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$9A8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS4
	LDA	CLRFLR
	JMP	FLR2FILLS3
WALL2LWRS4:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS5
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$A28,X
	LDA	CLRFLR
	JMP	FLR2FILLS4
WALL2LWRS5:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$A28,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS6
	LDA	CLRFLR
	JMP	FLR2FILLS4
WALL2LWRS6:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS7
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$AA8,X
	LDA	CLRFLR
	JMP	FLR2FILLS5
WALL2LWRS7:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$AA8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS8
	LDA	CLRFLR
	JMP	FLR2FILLS5
WALL2LWRS8:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS9
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$B28,X
	LDA	CLRFLR
	JMP	FLR2FILLS6
WALL2LWRS9:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$B28,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS10
	LDA	CLRFLR
	JMP	FLR2FILLS6
WALL2LWRS10:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS11
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$BA8,X
	LDA	CLRFLR
	JMP	FLR2FILLS7
WALL2LWRS11:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$BA8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS12
	LDA	CLRFLR
	JMP	FLR2FILLS7
WALL2LWRS12:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS13
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$850,X
	LDA	CLRFLR
	JMP	FLR2FILLS8
WALL2LWRS13:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$850,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS14
	LDA	CLRFLR
	JMP	FLR2FILLS8
WALL2LWRS14:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS15
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$8D0,X
	LDA	CLRFLR
	JMP	FLR2FILLS9
WALL2LWRS15:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$8D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS16
	LDA	CLRFLR
	JMP	FLR2FILLS9
WALL2LWRS16:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS17
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$950,X
	LDA	CLRFLR
	JMP	FLR2FILLS10
WALL2LWRS17:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$950,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS18
	LDA	CLRFLR
	JMP	FLR2FILLS10
WALL2LWRS18:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWRS19
	LDA	CLRFLR
	AND	#$F0	
	ORA	CLRTMP
	STA	$9D0,X
	LDA	HITCNT
	BNE	WALL2SPRTS1
	JMP	DRAWNEXT
WALL2SPRTS1:	JMP	SPRT2UPRS1
WALL2LWRS19:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$9D0,X
	LDA	HITCNT
	BNE	WALL2SPRTS2
	JMP	DRAWNEXT
WALL2SPRTS2:	JMP	SPRT2UPRS1
;
; DRAW FLOOR W/ STATUS
;
FLR2FILLS1:	STA	$928,X
FLR2FILLS2:	STA	$9A8,X
FLR2FILLS3:	STA	$A28,X
FLR2FILLS4:	STA	$AA8,X
FLR2FILLS5:	STA	$B28,X
FLR2FILLS6:	STA	$BA8,X
FLR2FILLS7:	STA	$850,X
FLR2FILLS8:	STA	$8D0,X
FLR2FILLS9:	STA	$950,X
FLR2FILLS10:	STA	$9D0,X
	LDA	HITCNT
	BNE	WALL2SPRTS3
	JMP	DRAWNEXT
WALL2SPRTS3:	JMP	SPRT2UPRS1
;
; DRAW UPPER HALF OF WALL - PAGE 2
;
WALL2UPR:	LDX	VIEWCOL
	LDA	#WALLUPRORGFRAC
	STA	WALLINDX
	LDY	#WALLUPRORGINT
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR1
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$9A8,X
	LDA	CLRCEIL
	JMP	CEIL2FILL2
WALL2UPR1:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$9A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR2
	LDA	CLRCEIL
	JMP	CEIL2FILL2
WALL2UPR2:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR3
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$928,X
	LDA	CLRCEIL
	JMP	CEIL2FILL3
WALL2UPR3:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$928,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR4
	LDA	CLRCEIL
	JMP	CEIL2FILL3
WALL2UPR4:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR5
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$8A8,X
	LDA	CLRCEIL
	JMP	CEIL2FILL4
WALL2UPR5:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$8A8,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR6
	LDA	CLRCEIL
	JMP	CEIL2FILL4
WALL2UPR6:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR7
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$828,X
	LDA	CLRCEIL
	JMP	CEIL2FILL5
WALL2UPR7:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$828,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR8
	LDA	CLRCEIL
	JMP	CEIL2FILL5
WALL2UPR8:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR9
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$B80,X
	LDA	CLRCEIL
	JMP	CEIL2FILL6
WALL2UPR9:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$B80,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR10
	LDA	CLRCEIL
	JMP	CEIL2FILL6
WALL2UPR10:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR11
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$B00,X
	LDA	CLRCEIL
	JMP	CEIL2FILL7
WALL2UPR11:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$B00,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR12
	LDA	CLRCEIL
	JMP	CEIL2FILL7
WALL2UPR12:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR13
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$A80,X
	LDA	CLRCEIL
	JMP	CEIL2FILL8
WALL2UPR13:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$A80,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR14
	LDA	CLRCEIL
	JMP	CEIL2FILL8
WALL2UPR14:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR15
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$A00,X
	LDA	CLRCEIL
	JMP	CEIL2FILL9
WALL2UPR15:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$A00,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR16
	LDA	CLRCEIL
	JMP	CEIL2FILL9
WALL2UPR16:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR17
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$980,X
	LDA	CLRCEIL
	JMP	CEIL2FILL10
WALL2UPR17:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$980,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR18
	LDA	CLRCEIL
	JMP	CEIL2FILL10
WALL2UPR18:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR19
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$900,X
	LDA	CLRCEIL
	JMP	CEIL2FILL11
WALL2UPR19:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$900,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR20
	LDA	CLRCEIL
	JMP	CEIL2FILL11
WALL2UPR20:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR21
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$880,X
	LDA	CLRCEIL
	JMP	CEIL2FILL12
WALL2UPR21:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$880,X
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR22
	LDA	CLRCEIL
	JMP	CEIL2FILL12
WALL2UPR22:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	STA	CLRTMP
	LDA	WALLINDX
	SEC
	SBC	WALLSCALE
	STA	WALLINDX
	TYA
	SBC	WALLSCALE+1
	BPL	WALL2UPR23
	LDA	CLRCEIL
	AND	#$0F
	ORA	CLRTMP
	STA	$800,X	
	JMP	WALL2LWR
WALL2UPR23:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	ORA	CLRTMP
	STA	$800,X	
	JMP	WALL2LWR
;
; DRAW CEILING 
;
CEIL2FILL1:	STA	$9A8,X
CEIL2FILL2:	STA	$928,X
CEIL2FILL3:	STA	$8A8,X
CEIL2FILL4:	STA	$828,X
CEIL2FILL5:	STA	$B80,X
CEIL2FILL6:	STA	$B00,X
CEIL2FILL7:	STA	$A80,X
CEIL2FILL8:	STA	$A00,X
CEIL2FILL9:	STA	$980,X
CEIL2FILL10:	STA	$900,X
CEIL2FILL11:	STA	$880,X
CEIL2FILL12:	STA	$800,X
;
; DRAW LOWER HALF OF WALL
;
WALL2LWR:	LDA	#WALLLWRORGFRAC
	STA	WALLINDX
	LDY	#WALLLWRORGINT
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	CLC
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR1
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$A28,X
	LDA	CLRFLR
	JMP	FLR2FILL2
WALL2LWR1:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$A28,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR2
	LDA	CLRFLR
	JMP	FLR2FILL2
WALL2LWR2:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR3
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$AA8,X
	LDA	CLRFLR
	JMP	FLR2FILL3
WALL2LWR3:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$AA8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR4
	LDA	CLRFLR
	JMP	FLR2FILL3
WALL2LWR4:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR5
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$B28,X
	LDA	CLRFLR
	JMP	FLR2FILL4
WALL2LWR5:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$B28,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR6
	LDA	CLRFLR
	JMP	FLR2FILL4
WALL2LWR6:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR7
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$BA8,X
	LDA	CLRFLR
	JMP	FLR2FILL5
WALL2LWR7:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$BA8,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR8
	LDA	CLRFLR
	JMP	FLR2FILL5
WALL2LWR8:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR9
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$850,X
	LDA	CLRFLR
	JMP	FLR2FILL6
WALL2LWR9:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$850,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR10
	LDA	CLRFLR
	JMP	FLR2FILL6
WALL2LWR10:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR11
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$8D0,X
	LDA	CLRFLR
	JMP	FLR2FILL7
WALL2LWR11:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$8D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR12
	LDA	CLRFLR
	JMP	FLR2FILL7
WALL2LWR12:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR13
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$950,X
	LDA	CLRFLR
	JMP	FLR2FILL8
WALL2LWR13:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$950,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR14
	LDA	CLRFLR
	JMP	FLR2FILL8
WALL2LWR14:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR15
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$9D0,X
	LDA	CLRFLR
	JMP	FLR2FILL9
WALL2LWR15:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$9D0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR16
	LDA	CLRFLR
	JMP	FLR2FILL9
WALL2LWR16:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR17
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$A50,X
	LDA	CLRFLR
	JMP	FLR2FILL10
WALL2LWR17:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$A50,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR18
	LDA	CLRFLR
	JMP	FLR2FILL10
WALL2LWR18:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR19
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$AD0,X
	LDA	CLRFLR
	JMP	FLR2FILL11
WALL2LWR19:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$AD0,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR20
	LDA	CLRFLR
	JMP	FLR2FILL11
WALL2LWR20:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR21
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$B50,X
	LDA	CLRFLR
	JMP	FLR2FILL12
WALL2LWR21:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$B50,X
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR22
	LDA	CLRFLR
	JMP	FLR2FILL12
WALL2LWR22:	TAY
	LDA	(TEXPTR),Y
	AND	#$0F
	STA	CLRTMP
	LDA	WALLINDX
	ADC	WALLSCALE
	STA	WALLINDX
	TYA
	ADC	WALLSCALE+1
	CMP	#$10
	BCC	WALL2LWR23
	LDA	CLRFLR
	AND	#$F0
	ORA	CLRTMP
	STA	$BD0,X
	LDA	HITCNT
	BNE	WALL2SPRT1
	JMP	DRAWNEXT
WALL2SPRT1:	JMP	SPRT2UPR1
WALL2LWR23:	TAY
	LDA	(TEXPTR),Y
	AND	#$F0
	ORA	CLRTMP
	STA	$BD0,X
	LDA	HITCNT
	BNE	WALL2SPRT2
	JMP	DRAWNEXT
WALL2SPRT2:	JMP	SPRT2UPR1
;
; DRAW FLOOR
;
FLR2FILL1:	STA	$A28,X
FLR2FILL2:	STA	$AA8,X
FLR2FILL3:	STA	$B28,X
FLR2FILL4:	STA	$BA8,X
FLR2FILL5:	STA	$850,X
FLR2FILL6:	STA	$8D0,X
FLR2FILL7:	STA	$950,X
FLR2FILL8:	STA	$9D0,X
FLR2FILL9:	STA	$A50,X
FLR2FILL10:	STA	$AD0,X
FLR2FILL11:	STA	$B50,X
FLR2FILL12:	STA	$BD0,X
	LDA	HITCNT
	BNE	WALL2SPRT3
	JMP	DRAWNEXT
WALL2SPRT3:	JMP	SPRT2UPR1
;
; DRAW UPPER HALF OF SPRITE W/ STATUS - PAGE 1
;
SPRT1UPRS:	LDA	HITCNT
	BNE	SPRT1UPRS1
	JMP	DRAWNEXT
SPRT1UPRS1:	TAY
	SEC
	SBC	#$08
	STA	HITCNT
	LDA	HITDIST+1,Y
	LSR
	STA	SPRTSCALE+1
	LDA	HITDIST,Y
	ROR
	STA	SPRTSCALE
	LSR	SPRTSCALE+1
	ROR	SPRTSCALE
	LDA	HITX,Y	;HORIZ HIT, USE HITX
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	SPRTBASE
	STA	SPRTPTR
	LDA	HITOBJ,Y
	ADC	SPRTBASE+1
	STA	SPRTPTR+1
	LDA	#SPRTUPRORGFRAC
	STA	SPRTINDX
	LDY	#SPRTUPRORGINT
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS1
	STA	$4A8,X
SPRT1XUPRS1:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS2
	JMP	SPRT1LWRS
SPRT1UPRS2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS2
	STA	$428,X
SPRT1XUPRS2:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS4
	JMP	SPRT1LWRS
SPRT1UPRS4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS4
	STA	$780,X
SPRT1XUPRS4:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS6
	JMP	SPRT1LWRS
SPRT1UPRS6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS6
	STA	$700,X
SPRT1XUPRS6:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS8
	JMP	SPRT1LWRS
SPRT1UPRS8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS8
	STA	$680,X
SPRT1XUPRS8:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS10
	JMP	SPRT1LWRS
SPRT1UPRS10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS10
	STA	$600,X
SPRT1XUPRS10:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS12
	JMP	SPRT1LWRS
SPRT1UPRS12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS12
	STA	$580,X
SPRT1XUPRS12:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS14
	JMP	SPRT1LWRS
SPRT1UPRS14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS14
	STA	$500,X
SPRT1XUPRS14:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPRS16
	JMP	SPRT1LWRS
SPRT1UPRS16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPRS16
	STA	$480,X
SPRT1XUPRS16:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BMI	SPRT1LWRS
SPRT1UPRS18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1LWRS
	STA	$400,X
;
; DRAW LOWER HALF OF SPRITE W/ STATUS
;
SPRT1LWRS:	LDA	#SPRTLWRORGFRAC
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	LDA	#SPRTLWRORGINT
SPRT1LWRS1:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS1
	STA	$528,X
SPRT1XLWRS1:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS2
	JMP	SPRT1UPRS
SPRT1LWRS2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS2
	STA	$5A8,X
SPRT1XLWRS2:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS4
	JMP	SPRT1UPRS
SPRT1LWRS4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS4
	STA	$628,X
SPRT1XLWRS4:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS6
	JMP	SPRT1UPRS
SPRT1LWRS6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS6
	STA	$6A8,X
SPRT1XLWRS6:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS8
	JMP	SPRT1UPRS
SPRT1LWRS8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS8
	STA	$728,X
SPRT1XLWRS8:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS10
	JMP	SPRT1UPRS
SPRT1LWRS10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS10
	STA	$7A8,X
SPRT1XLWRS10:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS12
	JMP	SPRT1UPRS
SPRT1LWRS12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS12
	STA	$450,X
SPRT1XLWRS12:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS14
	JMP	SPRT1UPRS
SPRT1LWRS14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS14
	STA	$4D0,X
SPRT1XLWRS14:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS16
	JMP	SPRT1UPRS
SPRT1LWRS16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS16
	STA	$550,X
SPRT1XLWRS16:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWRS18
	JMP	SPRT1UPRS
SPRT1LWRS18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWRS18
	STA	$5D0,X
SPRT1XLWRS18:	JMP	SPRT1UPRS
;
; DRAW UPPER HALF OF SPRITE - PAGE 1
;
SPRT1UPR:	LDA	HITCNT
	BNE	SPRT1UPR1
	JMP	DRAWNEXT
SPRT1UPR1:	TAY
	SEC
	SBC	#$08
	STA	HITCNT
	LDA	HITDIST+1,Y
	LSR
	STA	SPRTSCALE+1
	LDA	HITDIST,Y
	ROR
	STA	SPRTSCALE
	LSR	SPRTSCALE+1
	ROR	SPRTSCALE
	LDA	HITX,Y	;HORIZ HIT, USE HITX
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	SPRTBASE
	STA	SPRTPTR
	LDA	HITOBJ,Y
	ADC	SPRTBASE+1
	STA	SPRTPTR+1
	LDA	#SPRTUPRORGFRAC
	STA	SPRTINDX
	LDY	#SPRTUPRORGINT
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR1
	STA	$5A8,X
SPRT1XUPR1:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR2
	JMP	SPRT1LWR
SPRT1UPR2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR2
	STA	$528,X
SPRT1XUPR2:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR4
	JMP	SPRT1LWR
SPRT1UPR4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR4
	STA	$4A8,X
SPRT1XUPR4:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR6
	JMP	SPRT1LWR
SPRT1UPR6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR6
	STA	$428,X
SPRT1XUPR6:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR8
	JMP	SPRT1LWR
SPRT1UPR8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR8
	STA	$780,X
SPRT1XUPR8:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR10
	JMP	SPRT1LWR
SPRT1UPR10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR10
	STA	$700,X
SPRT1XUPR10:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR12
	JMP	SPRT1LWR
SPRT1UPR12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR12
	STA	$680,X
SPRT1XUPR12:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR14
	JMP	SPRT1LWR
SPRT1UPR14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR14
	STA	$600,X
SPRT1XUPR14:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR16
	JMP	SPRT1LWR
SPRT1UPR16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR16
	STA	$580,X
SPRT1XUPR16:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR18
	JMP	SPRT1LWR
SPRT1UPR18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR18
	STA	$500,X
SPRT1XUPR18:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT1UPR20
	JMP	SPRT1LWR
SPRT1UPR20:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XUPR20
	STA	$480,X
SPRT1XUPR20:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BMI	SPRT1LWR
SPRT1UPR22:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1LWR
	STA	$400,X	
;
; DRAW LOWER HALF OF SPRT
;
SPRT1LWR:	LDA	#SPRTLWRORGFRAC
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	LDA	#SPRTLWRORGINT
SPRT1LWR1:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR1
	STA	$628,X
SPRT1XLWR1:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR2
	JMP	SPRT1UPR
SPRT1LWR2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR2
	STA	$6A8,X
SPRT1XLWR2:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR4
	JMP	SPRT1UPR
SPRT1LWR4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR4
	STA	$728,X
SPRT1XLWR4:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR6
	JMP	SPRT1UPR
SPRT1LWR6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR6
	STA	$7A8,X
SPRT1XLWR6:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR8
	JMP	SPRT1UPR
SPRT1LWR8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR8
	STA	$450,X
SPRT1XLWR8:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR10
	JMP	SPRT1UPR
SPRT1LWR10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR10
	STA	$4D0,X
SPRT1XLWR10:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR12
	JMP	SPRT1UPR
SPRT1LWR12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR12
	STA	$550,X
SPRT1XLWR12:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR14
	JMP	SPRT1UPR
SPRT1LWR14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR14
	STA	$5D0,X
SPRT1XLWR14:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR16
	JMP	SPRT1UPR
SPRT1LWR16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR16
	STA	$650,X
SPRT1XLWR16:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR18
	JMP	SPRT1UPR
SPRT1LWR18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR18
	STA	$6D0,X
SPRT1XLWR18:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR20
	JMP	SPRT1UPR
SPRT1LWR20:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR20
	STA	$750,X
SPRT1XLWR20:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT1LWR22
	JMP	SPRT1UPR
SPRT1LWR22:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT1XLWR22
	STA	$7D0,X
SPRT1XLWR22:	JMP	SPRT1UPR
;
; DRAW UPPER HALF OF SPRT W/ STATUS - PAGE 2
;
SPRT2UPRS:	LDA	HITCNT
	BNE	SPRT2UPRS1
	JMP	DRAWNEXT
SPRT2UPRS1:	TAY
	SEC
	SBC	#$08
	STA	HITCNT
	LDA	HITDIST+1,Y
	LSR
	STA	SPRTSCALE+1
	LDA	HITDIST,Y
	ROR
	STA	SPRTSCALE
	LSR	SPRTSCALE+1
	ROR	SPRTSCALE
	LDA	HITX,Y	;HORIZ HIT, USE HITX
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	SPRTBASE
	STA	SPRTPTR
	LDA	HITOBJ,Y
	ADC	SPRTBASE+1
	STA	SPRTPTR+1
	LDA	#SPRTUPRORGFRAC
	STA	SPRTINDX
	LDY	#SPRTUPRORGINT
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS1
	STA	$8A8,X
SPRT2XUPRS1:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS2
	JMP	SPRT2LWRS
SPRT2UPRS2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS2
	STA	$828,X
SPRT2XUPRS2:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS4
	JMP	SPRT2LWRS
SPRT2UPRS4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS4
	STA	$B80,X
SPRT2XUPRS4:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS6
	JMP	SPRT2LWRS
SPRT2UPRS6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS6
	STA	$B00,X
SPRT2XUPRS6:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS8
	JMP	SPRT2LWRS
SPRT2UPRS8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS8
	STA	$A80,X
SPRT2XUPRS8:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS10
	JMP	SPRT2LWRS
SPRT2UPRS10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS10
	STA	$A00,X
SPRT2XUPRS10:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS12
	JMP	SPRT2LWRS
SPRT2UPRS12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS12
	STA	$980,X
SPRT2XUPRS12:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS14
	JMP	SPRT2LWRS
SPRT2UPRS14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS14
	STA	$900,X
SPRT2XUPRS14:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPRS16
	JMP	SPRT2LWRS
SPRT2UPRS16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPRS16
	STA	$880,X
SPRT2XUPRS16:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BMI	SPRT2LWRS
SPRT2UPRS18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2LWRS
	STA	$800,X
;
; DRAW LOWER HALF OF SPRITE W/ STATUS
;
SPRT2LWRS:	LDA	#SPRTLWRORGFRAC
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	LDA	#SPRTLWRORGINT
SPRT2LWRS1:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS1
	STA	$928,X
SPRT2XLWRS1:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS2
	JMP	SPRT2UPRS
SPRT2LWRS2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS2
	STA	$9A8,X
SPRT2XLWRS2:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS4
	JMP	SPRT2UPRS
SPRT2LWRS4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS4
	STA	$A28,X
SPRT2XLWRS4:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS6
	JMP	SPRT2UPRS
SPRT2LWRS6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS6
	STA	$AA8,X
SPRT2XLWRS6:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS8
	JMP	SPRT2UPRS
SPRT2LWRS8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS8
	STA	$B28,X
SPRT2XLWRS8:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS10
	JMP	SPRT2UPRS
SPRT2LWRS10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS10
	STA	$BA8,X
SPRT2XLWRS10:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS12
	JMP	SPRT2UPRS
SPRT2LWRS12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS12
	STA	$850,X
SPRT2XLWRS12:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS14
	JMP	SPRT2UPRS
SPRT2LWRS14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS14
	STA	$8D0,X
SPRT2XLWRS14:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS16
	JMP	SPRT2UPRS
SPRT2LWRS16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS16
	STA	$950,X
SPRT2XLWRS16:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWRS18
	JMP	SPRT2UPRS
SPRT2LWRS18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWRS18
	STA	$9D0,X
SPRT2XLWRS18:	JMP	SPRT2UPRS
;
; DRAW UPPER HALF OF SPRITE - PAGE 2
;
SPRT2UPR:	LDA	HITCNT
	BNE	SPRT2UPR1
	JMP	DRAWNEXT
SPRT2UPR1:	TAY
	SEC
	SBC	#$08
	STA	HITCNT
	LDA	HITDIST+1,Y
	LSR
	STA	SPRTSCALE+1
	LDA	HITDIST,Y
	ROR
	STA	SPRTSCALE
	LSR	SPRTSCALE+1
	ROR	SPRTSCALE
	LDA	HITX,Y	;HORIZ HIT, USE HITX
	AND	#$F0	;TO INDEX INTO WALL
	CLC
	ADC	SPRTBASE
	STA	SPRTPTR
	LDA	HITOBJ,Y
	ADC	SPRTBASE+1
	STA	SPRTPTR+1
	LDA	#SPRTUPRORGFRAC
	STA	SPRTINDX
	LDY	#SPRTUPRORGINT
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR1
	STA	$9A8,X
SPRT2XUPR1:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR2
	JMP	SPRT2LWR
SPRT2UPR2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR2
	STA	$928,X
SPRT2XUPR2:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR4
	JMP	SPRT2LWR
SPRT2UPR4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR4
	STA	$8A8,X
SPRT2XUPR4:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR6
	JMP	SPRT2LWR
SPRT2UPR6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR6
	STA	$828,X
SPRT2XUPR6:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR8
	JMP	SPRT2LWR
SPRT2UPR8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR8
	STA	$B80,X
SPRT2XUPR8:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR10
	JMP	SPRT2LWR
SPRT2UPR10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR10
	STA	$B00,X
SPRT2XUPR10:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR12
	JMP	SPRT2LWR
SPRT2UPR12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR12
	STA	$A80,X
SPRT2XUPR12:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR14
	JMP	SPRT2LWR
SPRT2UPR14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR14
	STA	$A00,X
SPRT2XUPR14:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR16
	JMP	SPRT2LWR
SPRT2UPR16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR16
	STA	$980,X
SPRT2XUPR16:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR18
	JMP	SPRT2LWR
SPRT2UPR18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR18
	STA	$900,X
SPRT2XUPR18:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BPL	SPRT2UPR20
	JMP	SPRT2LWR
SPRT2UPR20:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XUPR20
	STA	$880,X
SPRT2XUPR20:	LDA	SPRTINDX
	SEC
	SBC	SPRTSCALE
	STA	SPRTINDX
	TYA
	SBC	SPRTSCALE+1
	BMI	SPRT2LWR
SPRT2UPR22:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2LWR
	STA	$800,X
;
; DRAW LOWER HALF OF SPRT
;
SPRT2LWR:	LDA	#SPRTLWRORGFRAC
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	LDA	#SPRTLWRORGINT
SPRT2LWR1:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR1
	STA	$A28,X
SPRT2XLWR1:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR2
	JMP	SPRT2UPR
SPRT2LWR2:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR2
	STA	$AA8,X
SPRT2XLWR2:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR4
	JMP	SPRT2UPR
SPRT2LWR4:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR4
	STA	$B28,X
SPRT2XLWR4:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR6
	JMP	SPRT2UPR
SPRT2LWR6:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR6
	STA	$BA8,X
SPRT2XLWR6:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR8
	JMP	SPRT2UPR
SPRT2LWR8:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR8
	STA	$850,X
SPRT2XLWR8:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR10
	JMP	SPRT2UPR
SPRT2LWR10:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR10
	STA	$8D0,X
SPRT2XLWR10:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR12
	JMP	SPRT2UPR
SPRT2LWR12:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR12
	STA	$950,X
SPRT2XLWR12:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR14
	JMP	SPRT2UPR
SPRT2LWR14:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR14
	STA	$9D0,X
SPRT2XLWR14:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR16
	JMP	SPRT2UPR
SPRT2LWR16:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR16
	STA	$A50,X
SPRT2XLWR16:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR18
	JMP	SPRT2UPR
SPRT2LWR18:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR18
	STA	$AD0,X
SPRT2XLWR18:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR20
	JMP	SPRT2UPR
SPRT2LWR20:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR20
	STA	$B50,X
SPRT2XLWR20:	LDA	SPRTINDX
	CLC
	ADC	SPRTSCALE
	STA	SPRTINDX
	TYA
	ADC	SPRTSCALE+1
	CMP	#$10
	BCC	SPRT2LWR22
	JMP	SPRT2UPR
SPRT2LWR22:	TAY
	LDA	(SPRTPTR),Y
	CMP	#$AA
	BEQ	SPRT2XLWR22
	STA	$BD0,X
SPRT2XLWR22:	JMP	SPRT2UPR
;
; BOTTOM OF LOOP
;
DRAWNEXT:	INX
	CPX	VIEWCOLRIGHT
	BEQ	RENDERDONE
	STX	VIEWCOL
	INC	RAYA
	CPX	#20
	BEQ	VIEWAHEAD
	JMP	RENDERLOOP
VIEWAHEAD:	LDA	HITOBJ	;SAVE OBJECT DIRECTLY AHEAD OF PLAYER
	STA	AHEADOBJ
	LDA	MAPPTR
	STA	AHEADPTR
	LDA	MAPPTR+1
	STA	AHEADPTR+1
	LDA	HITX
	STA	AHEADX
	LDA	HITX+1
	STA	AHEADX+1
	LDA	HITY
	STA	AHEADY
	LDA	HITY+1
	STA	AHEADY+1
	LDA	HITDIST
	STA	AHEADDST
	LDA	HITDIST+1
	STA	AHEADDST+1
	JMP	RENDERLOOP
RENDERDONE:	RTS
	
	.DATA
	
VIEWCOL:	.RES	1
